//
//  TTTGameGrid.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTGameGrid.h"
#import "TTTSquare.h"

@implementation TTTGameGrid

    - (id) init{ // Initializer. Sets the grid to blanks
		for (int i=0; i<GAMEGRIDSIZE;i++)
			for(int j=0; j<GAMEGRIDSIZE; j++)
				self->grid[i][j] = [TTTSymbol SymbolBlankCreate];
        return self;
	}

    - (id) initFromArrayOfInt :(NSArray *) arrayOfInt{
        for(int i = 0; i < GAMEGRIDSIZE; i++) {
            for(int j = 0; j < GAMEGRIDSIZE; j++) {
                grid[i][j] = [TTTSymbol CreateSymbolFromInt:[[arrayOfInt objectAtIndex:(i*GAMEGRIDSIZE+j)] intValue]];
            }
        }
        return self;
    }

    - (id) initFromString: (NSString *) savedGameString{
        NSArray *savedGameArray = [savedGameString componentsSeparatedByString:@","];
        for (int i = 0; i < [savedGameArray count]; i++) {
            grid[i/GAMEGRIDSIZE][i%GAMEGRIDSIZE] = [TTTSymbol CreateSymbolFromInt:[[savedGameArray objectAtIndex:i] intValue]];
        }
        return self;
    }

	-(void) setValueAtLocation: (int) x :(int) y :(TTTSymbol *) value {
		if (((x>=0)&&(x< GAMEGRIDSIZE)) && ((y>=0)&&(y<GAMEGRIDSIZE)))
			grid[x][y] = value;
	}

	-(TTTSymbol *) getValueAtLocation: (int) x :(int) y {
		TTTSymbol *returnValue=nil;
		if (((x>=0)&&(x< GAMEGRIDSIZE)) && ((y>=0)&&(y<GAMEGRIDSIZE)))returnValue = grid[x][y];
		return returnValue;
	}

	-(BOOL) isRowFilled: (int) row {//Entire row has the same symbol
		BOOL isFilled=false;
		BOOL foundMismatch=false;
		for(int col = 0; (col < GAMEGRIDSIZE)&&(!foundMismatch); col++){
			if(grid[row][0] != grid[row][col])
				foundMismatch=true;
		}
		isFilled = (!foundMismatch) && (grid[row][0]!= [TTTSymbol SymbolBlankCreate]);
		return isFilled;
	}

	-(BOOL) isColumnFilled: (int) column {//Entire column has the same symbol
		BOOL isFilled=false;
		BOOL foundMismatch=false;
		for(int row = 0; (row < GAMEGRIDSIZE)&&(!foundMismatch); row++){
			if(grid[0][column] != grid[row][column]) foundMismatch=true;
		}
		isFilled = (!foundMismatch) && (grid[0][column]!=[TTTSymbol SymbolBlankCreate]);
		return isFilled;
	}

	-(BOOL) isLeftToRightDiagonalFilled {//Left diagonal has the same symbol
		BOOL isFilled=false;
		BOOL foundMismatch=false;
		for(int index = 0; (index < GAMEGRIDSIZE)&&(!foundMismatch); index++){
			if(grid[0][0] != grid[index][index]) foundMismatch=true;
		}
		isFilled = (!foundMismatch) && (grid[0][0]!=[TTTSymbol SymbolBlankCreate]);
		return isFilled;
	}

	-(BOOL) isRightToLeftDiagonalFilled{//Right diagonal has the same symbol
		int foundIndex=-1;
		BOOL isFilled=false;
		BOOL foundMismatch=false;
		for(int index = GAMEGRIDSIZE-1; (index >= 0)&&(!foundMismatch); index--){
			if(grid[0][GAMEGRIDSIZE-1] != grid[GAMEGRIDSIZE-1-index][index]){
				foundMismatch=true;
				foundIndex=index;
			}
		}
		isFilled = (!foundMismatch) && (grid[0][GAMEGRIDSIZE-1]!=[TTTSymbol SymbolBlankCreate]);
		return isFilled;
	}
	
	-(NSMutableArray *) getEmptySquares{//Get the unfilled squares
        NSMutableArray *list = [[NSMutableArray alloc] init];
		for(int i = 0; i < GAMEGRIDSIZE; i++) {
			for(int j = 0; j < GAMEGRIDSIZE; j++) {
				if(grid[i][j] == [TTTSymbol SymbolBlankCreate]) {
					TTTSquare *b = [[TTTSquare alloc] initWithXY :i :j];
					[list addObject:b];
				}
			}
		}
		return list;
	}

    - (NSMutableArray *) toArrayOfInt {
        NSMutableArray* retVal= [NSMutableArray array];
            
        for(int i = 0; i < GAMEGRIDSIZE; i++) {
            for(int j = 0; j < GAMEGRIDSIZE; j++) {
                NSLog(@"Gamegrid %d %d %d", i, j, [grid[i][j] toInt]);
                [retVal addObject:[NSNumber numberWithInteger:[grid[i][j] toInt]]];
            }
        }
        return retVal;
    }

    - (NSString *) toString {
        NSString *retVal=nil;
        NSMutableArray* gameGridArray = [self toArrayOfInt];
        NSMutableString* savedGameString = [[NSMutableString alloc] init];
        for (int i = 0; i < [gameGridArray count]-1; i++) {
            [savedGameString appendFormat:@"%@,", [gameGridArray objectAtIndex:i]];
        }
        [savedGameString appendFormat:@"%@", [gameGridArray objectAtIndex:[gameGridArray count]-1]];
        retVal = [NSString stringWithString:savedGameString];
        return retVal;
    }

@end
